@extends($activeTemplate . 'layouts.master')

@section('content')
    <div class="container py-60">
        <div class="row justify-content-center">
            <div class="col-xl-10">
                <div class="pb-40">
                    <div class="cart-step">
                        <div class="row g-2 g-md-3">
                            <div class="col">
                                <div class="cart-step-box position-relative {{ menuActive('cart.page') }}">
                                    <a href="{{ route('cart.page') }}" class="cart-link"></a>
                                    <div class="cart-step-icon mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50" x="0" y="0" viewBox="0 0 256 256" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path fill="hsl(var(--base))" d="m230.8 132.2-18.5-74.4c-.3-1-1.3-1.7-2.3-1.5l-59.2 9.2c-1 .2-1.8 1.1-1.8 2.1l5 76.5c.1 2.3 2 4 4.3 3.9h.5l68.8-10.7c2.2-.3 3.8-2.5 3.4-4.7-.2-.1-.2-.3-.2-.4z" opacity="1" data-original="#fc657e" class=""></path><path fill="#f5c84c" d="m153.9 144.1-5-76.5c0-1.1.7-2 1.8-2.1l26.8-4.2-5.8-23.2c-.4-1.3-1.7-2.2-3-2l-78 12.1c-1.4.2-2.4 1.4-2.3 2.8l6.5 100.7c.1 3 2.7 5.3 5.6 5.2.2 0 .4 0 .6-.1l57.5-8.9c-2.2.3-4.4-1.2-4.7-3.4.1-.1 0-.2 0-.4z" opacity="1" data-original="#f5c84c" class=""></path><circle cx="108.9" cy="229.4" r="17.3" fill="#29589f" opacity="1" data-original="#29589f" class=""></circle><circle cx="194.3" cy="229.4" r="17.3" fill="#29589f" opacity="1" data-original="#29589f" class=""></circle><path fill="hsl(var(--base))" d="M38.4 54.6h-.6L8.3 51.7c-3.5-.3-6.1-3.4-5.8-6.9s3.4-6.1 6.9-5.8L39 41.9c3.5.3 6.1 3.5 5.7 7-.3 3.2-3 5.7-6.3 5.7z" opacity="1" data-original="#fc657e" class=""></path><path fill="#dae6f1" d="M215.9 200.1H96l10.4-15.1c3.7-5.4 9.4-9 15.9-10.1l79.9-13.1c3.3-.5 5.5-3.6 5-6.9-.5-2.9-3-5.1-6-5.1l-83.3 13.6c-8.7 2.1-16.3 7.3-21.4 14.6l-13.7 20c-2.8 4.1-1.8 9.7 2.3 12.5 1.5 1 3.3 1.6 5.1 1.6h125.7c3.3 0 6-2.7 6-6 .1-3.3-2.6-6-6-6z" opacity="1" data-original="#dae6f1" class=""></path><circle cx="108.9" cy="229.4" r="6.2" fill="#5290db" opacity="1" data-original="#5290db"></circle><circle cx="194.3" cy="229.4" r="6.2" fill="#5290db" opacity="1" data-original="#5290db"></circle><path fill="#70d6f9" d="M253.2 158.7h-2.1v-2.1c0-1.5-1.3-2.8-2.8-2.8s-2.8 1.3-2.8 2.8v2.1h-2.1c-1.5 0-2.8 1.3-2.8 2.8s1.3 2.8 2.8 2.8h2.1v2.1c0 1.5 1.3 2.8 2.8 2.8s2.8-1.3 2.8-2.8v-2.1h2.1c1.5 0 2.8-1.3 2.8-2.8s-1.3-2.8-2.8-2.8z" opacity="1" data-original="#70d6f9"></path><path fill="#f5c84c" d="M88.3 30.5c-4-.7-7.1-3.8-7.9-7.7 0-.1-.1-.2-.2-.1-.1 0-.1.1-.1.1-.8 4-3.9 7-7.9 7.7-.1 0-.2.1-.1.2 0 .1.1.1.1.1 4 .7 7.1 3.8 7.9 7.7 0 .1.1.2.2.1.1 0 .1-.1.1-.1.8-4 3.9-7 7.9-7.7.1 0 .2-.1.1-.2 0-.1 0-.1-.1-.1z" opacity="1" data-original="#f5c84c" class=""></path><circle cx="64" cy="52.8" r="3" fill="hsl(var(--base))" opacity="1" data-original="#fc657e" class=""></circle><circle cx="57" cy="139.8" r="3" fill="#87d147" opacity="1" data-original="#87d147" class=""></circle><circle cx="238" cy="180.8" r="3" fill="#f5c84c" opacity="1" data-original="#f5c84c" class=""></circle><path d="M8 54.2 37.5 57c.5.1 1.1.1 1.6 0L83 157.7c3.2 7.4 10.9 11.9 18.9 10.9-2.9 2.3-5.4 5-7.5 8.1l-13.7 19.8c-3.6 5.2-2.3 12.4 3 16 1.9 1.3 4.2 2 6.5 2h5.5c-8.2 7.2-8.9 19.7-1.7 27.9s19.7 8.9 27.9 1.7 8.9-19.7 1.7-27.9c-.5-.6-1.1-1.2-1.7-1.7h59.2c-8.2 7.2-8.9 19.7-1.7 27.9s19.7 8.9 27.9 1.7 8.9-19.7 1.7-27.9c-.5-.6-1.1-1.2-1.7-1.7h8.5c4.7 0 8.5-3.8 8.5-8.5s-3.8-8.5-8.5-8.5h-115l7.7-11.1c3.3-4.8 8.5-8.1 14.2-9l79.9-13.1c4.6-.8 7.8-5.1 7-9.8-.2-1.2-.6-2.3-1.3-3.3l23.2-3.8c5.2-.8 9-5.3 9-10.6V77.3c0-4.7-3.8-8.4-8.4-8.4h-.2l-14.3.4-3-12.2c-.6-2.2-2.8-3.7-5.1-3.3l-6.1.9-.2-1.3c-2-12.9-14.1-21.8-27-19.8-1.4.2-2.7.6-4.1 1-1.1-.8-2.5-1.2-3.9-1l-8.8 1.4-.4-2.5C156.5 16 140.9 4.7 124.4 7.3S96.6 25.4 99.1 41.9l.4 2.5-9.1 1.4c-2.6.4-4.6 2.8-4.4 5.4l1.4 21.6-35.4 1-8.1-18.5c3.9-3 4.6-8.6 1.6-12.5-1.5-1.9-3.7-3.2-6.2-3.4L9.7 36.6c-4.9-.5-9.2 3.1-9.7 8s3.1 9.2 8 9.6zm87.6 69.3L93 83.3l29.6 67.8-14 2.2zm7.8 30.6-2.6.4c-1.6.2-3.1-.8-3.3-2.4v-.4l-.9-13.4zm58-94.1c-1.2-7.4 2.2-14.7 8.5-18.7l4.5 18-12.8 2zm50.1 14.4 5.4 12.4 11.4 45.9v.1c.2.9-.3 1.8-1.1 2h-.2l-3.9.6-26.4-60.6zm-20.1.6 26.7 61.3-14 2.2-27.5-63zm16.1 71.3-1.4-3.2 14-2.2 1.3 3.1zm-38.1 6.3-1.5-3.5 14-2.2 1.5 3.4zm-3.5-8.2-11-25.3-2.6-40.3 27.6 63.5zm-7.6 1.1c-.9.1-1.7-.5-1.8-1.4v-.2l-.7-10.2 5 11.4zm4.5 4.4 1.5 3.5-13.9 2.3-1.6-3.6zm-17.5 6.6-13.9 2.3-1.6-3.8 14-2.2zm43.2-7-1.5-3.3 14-2.2 1.4 3.2zm-17.3-74 27.7 63.7-14 2.2-28.5-65.5zm-19.5-4.4-.2-3.2 6-.9.6 3.9zm-2.8 34.4-12.6-29 10.7-.3zm-18-28.9 19 43.6 1.6 24c0 .8.2 1.5.5 2.3l-5.2.8L116.1 77zm-20.2.6 30.9 70.9-14 2.2L96 77.6zm13.9 78.6 1.7 3.8-13.9 2.3-1.7-3.9zm-.9 73.6c0 8.2-6.6 14.8-14.8 14.8s-14.8-6.6-14.8-14.8 6.6-14.8 14.8-14.8 14.8 6.6 14.8 14.8zm85.4 0c0 8.2-6.6 14.8-14.8 14.8s-14.8-6.6-14.8-14.8 6.6-14.8 14.8-14.8 14.8 6.6 14.8 14.8zm-4.4-74.1c.3 1.9-1 3.7-2.9 4l-79.9 13.1c-7.1 1.2-13.4 5.2-17.5 11.1L94 198.7c-.8 1.1-.5 2.7.6 3.5.4.3.9.4 1.4.4h119.9c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5H90.3c-3.6 0-6.5-2.9-6.5-6.5 0-1.3.4-2.6 1.2-3.7l13.7-19.8c4.7-6.8 11.8-11.7 19.9-13.6l83-13.6c1.5.1 2.9 1.3 3.1 2.9zm26.1-12.8-4.2.7-1.3-3 2.6-.4c3.6-.6 6.1-4 5.5-7.6 0-.2-.1-.5-.1-.7l-4.3-17.1 6.7 15.4v7.1c-.1 2.8-2.1 5.2-4.9 5.6zm1.3-68.6c1.9-.1 3.5 1.4 3.5 3.3v40.1l-13.9-32-2.7-11zM210 58.8l2.6 10.6-49.5 1.3-.7-4.6 36.9-5.7.8 5.1c.2 1.4 1.5 2.3 2.9 2.1s2.3-1.5 2.1-2.9l-.8-5.1zm-33-20.2c10.2-1.6 19.7 5.4 21.3 15.6l.2 1.3-19.2 3-4.8-19.3c.9-.3 1.7-.5 2.5-.6zm-12.9.8c-1.2 1.1-2.4 2.3-3.4 3.7l-.5-3.1zM104 41.2c-2.2-13.8 7.2-26.9 21.1-29.1s26.9 7.2 29.1 21.1v.2l.4 2.5-50.2 7.8zm-12.9 9.6 9.1-1.4 1.2 7.5c.5 3.3 5.4 2.5 4.9-.8l-1.2-7.5 50.2-7.8 1.2 7.5c.1.6.4 1.1.9 1.5-1.2 3.5-1.5 7.3-.9 11l.2 1.3-6.3 1c-2.3.4-4 2.4-3.9 4.8l.2 3.4-54.4 1.5L90.9 51c0-.1.1-.2.2-.2zM89.7 110 75.8 78.1l11.8-.3zM70.4 78.3l20.2 46.5 1.8 27.2c.2 4.4 3.9 7.8 8.3 7.6.3 0 .6 0 .9-.1l3.9-.6 1.7 4-5.2.9c-6 1-11.9-2.2-14.4-7.8L54.1 78.7zM9.2 41.5l29.5 2.8c2.1.2 3.7 2.1 3.5 4.2S40.1 52.2 38 52L8.5 49.3C6.4 49.1 4.8 47.2 5 45c.2-2.1 2.1-3.7 4.2-3.5z" fill="#000000" opacity="1" data-original="#000000" class=""></path><path d="M108.9 238.1c4.8 0 8.7-3.9 8.7-8.7s-3.9-8.7-8.7-8.7-8.7 3.9-8.7 8.7 3.9 8.7 8.7 8.7zm0-12.4c2.1 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7c-2.1 0-3.7-1.7-3.7-3.7 0-2.1 1.7-3.7 3.7-3.7zM194.3 238.1c4.8 0 8.7-3.9 8.7-8.7s-3.9-8.7-8.7-8.7-8.7 3.9-8.7 8.7c0 4.8 3.9 8.7 8.7 8.7zm0-12.4c2.1 0 3.7 1.7 3.7 3.7 0 2.1-1.7 3.7-3.7 3.7-2.1 0-3.7-1.7-3.7-3.7 0-2.1 1.7-3.7 3.7-3.7z" fill="#000000" opacity="1" data-original="#000000" class=""></path></g></svg>
                                    </div>
                                    <p class="cart-step-title mb-0">@lang('My cart')</p>
                                </div>
                            </div>
                            <div class="col">
                                <div class="cart-step-box {{ menuActive('user.checkout.shipping.info') }}">
                                    <div class="cart-step-icon mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50" x="0" y="0" viewBox="0 0 128 128" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path fill="#dfeef4" d="M107.427 84.289H77.272A182.929 182.929 0 0 1 64 102.66a182.929 182.929 0 0 1-13.272-18.371H20.573L6.306 121.694h115.388z" opacity="1" data-original="#dfeef4" class=""></path><path fill="hsl(var(--base))" d="M64 6.31a30.711 30.711 0 0 0-30.71 30.71C33.11 66.32 64 102.66 64 102.66s30.89-36.34 30.71-65.64A30.711 30.711 0 0 0 64 6.31zm0 43.74a13.03 13.03 0 1 1 13.03-13.03A13.025 13.025 0 0 1 64 50.05z" opacity="1" data-original="#f45858" class=""></path><path fill="#575859" d="m110.74 92.96-57.58 20.48-22.44-29.15h20.01A182.752 182.752 0 0 0 64 102.66a182.752 182.752 0 0 0 13.27-18.37h30.16z" opacity="1" data-original="#f2da30" class=""></path><path fill="#00ab2e" d="m29.96 121.694 56.996-20.274 15.604 20.274z" opacity="1" data-original="#3ea2e5" class=""></path></g></svg>
                                    </div>
                                    <p class="cart-step-title mb-0">
                                        @lang('Shipping Info')
                                    </p>
                                </div>
                            </div>
                            <div class="col">
                                <div class="cart-step-box {{ menuActive('user.checkout.delivery.methods') }}">
                                    <div class="cart-step-icon mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50" x="0" y="0" viewBox="0 0 64 64" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><g data-name="Artboard 35"><path fill="hsl(var(--base))" d="M60 51V37.783L54 25H40v26z" opacity="1" data-original="#c12b35" class=""></path><path fill="#97262e" d="M48 42.644h-4a1 1 0 0 1 0-2h4a1 1 0 0 1 0 2z" opacity="1" data-original="#97262e" class=""></path><path fill="#ccced5" d="M56.658 55H62v-4H2v4h8.342z" opacity="1" data-original="#ccced5"></path><path fill="#f4ac1c" d="M4 51V19a2 2 0 0 1 2-2h32a2 2 0 0 1 2 2v32z" opacity="1" data-original="#f4ac1c" class=""></path><path fill="#ffc239" d="M24.543 46a10.109 10.109 0 0 0 10.109-10.109V20.872A3.871 3.871 0 0 0 30.78 17H6a2 2 0 0 0-2 2v27z" opacity="1" data-original="#ffc239" class=""></path><circle cx="51" cy="53" r="6" fill="#181a1c" opacity="1" data-original="#181a1c" class=""></circle><circle cx="16" cy="53" r="6" fill="#181a1c" opacity="1" data-original="#181a1c" class=""></circle><circle cx="51" cy="53" r="2" fill="#e0e2e6" opacity="1" data-original="#e0e2e6" class=""></circle><circle cx="16" cy="53" r="2" fill="#e0e2e6" opacity="1" data-original="#e0e2e6" class=""></circle><path fill="#76d8ff" d="M60 38H44V25h10l6 12.783" opacity="1" data-original="#76d8ff" class=""></path><path fill="#2b2e33" d="M48 42h-4a1 1 0 0 1 0-2h4a1 1 0 0 1 0 2z" opacity="1" data-original="#2b2e33" class=""></path><g fill="#f4ac1c"><path d="M14 45.693H5.147a1 1 0 1 1 0-2H14a1 1 0 0 1 0 2zM18 41.693H8a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2zM60 41h-4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h4z" fill="#f4ac1c" opacity="1" data-original="#f4ac1c" class=""></path></g><path fill="#2b2e33" d="M55 55a2 2 0 0 1-2-2 2 2 0 0 0-4 0 2 2 0 0 1-4 0 6 6 0 0 1 12 0 2 2 0 0 1-2 2zM20 55a2 2 0 0 1-2-2 2 2 0 0 0-4 0 2 2 0 0 1-4 0 6 6 0 0 1 12 0 2 2 0 0 1-2 2z" opacity="1" data-original="#2b2e33" class=""></path><rect width="18.147" height="4" x="24.446" y="51" fill="#f3f3f5" rx="2" opacity="1" data-original="#f3f3f5" class=""></rect><path fill="#f3f3f5" d="M2 51h6.549v.747A3.253 3.253 0 0 1 5.3 55H2v-4zM58.245 51H62v4h-1.432a2.323 2.323 0 0 1-2.323-2.323V51z" opacity="1" data-original="#f3f3f5" class=""></path><path fill="#ffc239" d="M56.3 41H60v3.288h-2.024a1.671 1.671 0 0 1-1.676-1.671V41z" opacity="1" data-original="#ffc239" class=""></path><path fill="#ccf1ff" d="M46.652 27.283v2.967a5.967 5.967 0 0 0 5.968 5.967h6.645L54 25h-5.065a2.283 2.283 0 0 0-2.283 2.283z" opacity="1" data-original="#ccf1ff" class=""></path><path fill="#ffda88" d="M5.065 25.367v-5.285a1.792 1.792 0 0 1 1.792-1.792h5.286a1.792 1.792 0 0 1 1.792 1.792 1.792 1.792 0 0 1-.525 1.267l-5.286 5.285a1.792 1.792 0 0 1-1.267.525 1.792 1.792 0 0 1-1.792-1.792z" opacity="1" data-original="#ffda88" class=""></path><path fill="#e63a45" d="M14 45H2a1 1 0 0 1 0-2h12a1 1 0 0 1 0 2zM18 41H8a1 1 0 0 1 0-2h10a1 1 0 0 1 0 2z" opacity="1" data-original="#e63a45" class=""></path><path fill="#f4ac1c" d="M31.975 17H12.612a9.652 9.652 0 0 0 1.918 5.213l6.132 10.73a1.877 1.877 0 0 0 3.261 0l6.135-10.735A9.656 9.656 0 0 0 31.975 17z" opacity="1" data-original="#f4ac1c" class=""></path><path fill="hsl(var(--base))" d="M15.1 19.4 22.3 32l7.2-12.6a9 9 0 1 0-14.4 0z" opacity="1" data-original="#c12b35" class=""></path><path fill="#e63a45" d="M29.492 19.4a9 9 0 0 0 .388-10.239 7.47 7.47 0 0 0-12.466 0A8.994 8.994 0 0 0 17.8 19.4l3.73 6.529a2.435 2.435 0 0 0 4.229 0z" opacity="1" data-original="#e63a45" class=""></path><circle cx="22.293" cy="14" r="5" fill="#f3f3f5" opacity="1" data-original="#f3f3f5" class=""></circle><path fill="#e0e2e6" d="M22.293 9a5.024 5.024 0 0 0-.847.085 4.985 4.985 0 0 1 0 9.83A4.994 4.994 0 1 0 22.293 9z" opacity="1" data-original="#e0e2e6" class=""></path><path fill="#eb616a" d="M24.368 25.293a1.5 1.5 0 0 1-1.283-2.274l1.851-3.069A1.5 1.5 0 1 1 27.5 21.5l-1.851 3.069a1.5 1.5 0 0 1-1.281.724z" opacity="1" data-original="#eb616a" class=""></path></g></g></svg>
                                    </div>
                                    <p class="cart-step-title mb-0">
                                        @lang('Delivery Info')
                                    </p>
                                </div>
                            </div>
                            <div class="col">
                                <div class="cart-step-box {{ menuActive(['user.checkout.payment.methods', 'user.deposit*']) }}">
                                    <div class="cart-step-icon mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path fill="#8cbafa" d="M20.832 17.61v271.5a4.13 4.13 0 0 0 4.129 4.128h185.32a4.13 4.13 0 0 0 4.13-4.129V17.61a4.128 4.128 0 0 0-4.13-4.129H24.961a4.128 4.128 0 0 0-4.129 4.13zm0 0" opacity="1" data-original="#8cbafa" class=""></path><path fill="#575b7a" d="M58.664 13.48H95.72v279.754H58.664zm0 0" opacity="1" data-original="#575b7a" class=""></path><path fill="#aed559" d="M264.23 1.762 131.695 191.039a4.133 4.133 0 0 0 1.016 5.75l155.926 109.18a4.128 4.128 0 0 0 5.75-1.012L426.922 115.68a4.129 4.129 0 0 0-1.016-5.75L269.98.746a4.129 4.129 0 0 0-5.75 1.016zm0 0" opacity="1" data-original="#aed559" class=""></path><path fill="#7fab38" d="m425.906 109.93-19.16-13.418c1.64 1.148 1.914 3.597.606 5.465L274.82 291.254c-1.308 1.867-3.703 2.45-5.343 1.297l19.16 13.418a4.128 4.128 0 0 0 5.75-1.012L426.922 115.68a4.128 4.128 0 0 0-1.016-5.75zm0 0" opacity="1" data-original="#7fab38"></path><path fill="#575b7a" d="M253.02 68.68a7.683 7.683 0 0 1-4.426-1.399c-3.496-2.445-4.344-7.265-1.899-10.761l11.266-16.083a7.715 7.715 0 0 1 10.758-1.898 7.8 7.8 0 0 0 5.855 1.3 7.8 7.8 0 0 0 5.063-3.226c.062-.093.125-.18.176-.27a7.731 7.731 0 0 1 11.132-2.484l16.95 11.871c3.496 2.446 4.343 7.262 1.898 10.758-2.45 3.496-7.27 4.348-10.762 1.899l-11.386-7.973a23.126 23.126 0 0 1-10.387 4.64 23.216 23.216 0 0 1-10.324-.495l-7.579 10.824a7.718 7.718 0 0 1-6.335 3.297zM375.125 154.18a7.692 7.692 0 0 1-4.426-1.399c-3.496-2.445-4.344-7.265-1.894-10.761l7.578-10.825a23.217 23.217 0 0 1-4-9.53c-.68-3.856-.39-7.731.808-11.349l-11.382-7.972a7.72 7.72 0 0 1-1.899-10.758 7.726 7.726 0 0 1 10.762-1.898l16.95 11.867a7.742 7.742 0 0 1 3.23 5.34 7.742 7.742 0 0 1-1.766 5.984c-.066.074-.121.152-.18.234a7.804 7.804 0 0 0-1.304 5.867 7.778 7.778 0 0 0 3.222 5.06 7.726 7.726 0 0 1 1.899 10.76l-11.262 16.087a7.725 7.725 0 0 1-6.336 3.293zm0 0" opacity="1" data-original="#575b7a" class=""></path><path fill="#ffeb96" d="M302.02 120.934c-20.672-14.473-53.723-2.93-73.825 25.777-20.101 28.707-19.64 63.71 1.032 78.184 20.668 14.476 53.718 2.933 73.82-25.774 20.101-28.707 19.64-63.715-1.027-78.187zm0 0" opacity="1" data-original="#ffeb96"></path><path fill="#575b7a" d="M249.86 238.906c-9.235 0-17.805-2.578-25.079-7.672-12.09-8.464-18.87-22.664-19.097-39.98-.215-16.375 5.527-33.766 16.171-48.965 10.641-15.2 25.016-26.543 40.477-31.941 16.352-5.707 32.016-4.192 44.102 4.27 12.086 8.464 18.87 22.663 19.097 39.984.215 16.37-5.527 33.761-16.172 48.96-10.64 15.2-25.02 26.543-40.476 31.942-6.512 2.273-12.914 3.402-19.024 3.402zm31.425-116.48c-4.379 0-9.047.832-13.86 2.511-12.425 4.34-24.112 13.649-32.913 26.215-17.625 25.172-18.016 55.418-.867 67.422 17.148 12.008 45.433 1.297 63.058-23.875 8.8-12.566 13.55-26.734 13.375-39.894-.16-12.215-4.601-21.993-12.508-27.528-4.605-3.226-10.168-4.851-16.285-4.851zm21.746 76.707h.012zm0 0" opacity="1" data-original="#575b7a" class=""></path><path fill="hsl(var(--base))" d="M0 201.66v232.613c0 16.778 13.602 30.38 30.379 30.38H366.07c16.778 0 30.38-13.602 30.38-30.38V201.66c0-16.777-13.602-30.379-30.38-30.379H30.38C13.602 171.281 0 184.883 0 201.661zm0 0" opacity="1" data-original="#f28f88" class=""></path><path fill="hsl(var(--base))" d="M366.07 171.281h-25.648c16.777 0 30.379 13.602 30.379 30.38v232.612c0 16.778-13.602 30.38-30.38 30.38h25.65c16.777 0 30.378-13.602 30.378-30.38V201.66c0-16.777-13.601-30.379-30.379-30.379zm0 0" opacity="1" data-original="#ce675d" class=""></path><path fill="#ffd2c0" d="M395.012 365.734h-61.598c-26.383 0-47.77-21.386-47.77-47.77 0-26.378 21.387-47.769 47.77-47.769h61.598c17.652 0 31.965 14.313 31.965 31.97v31.605c0 17.652-14.313 31.964-31.965 31.964zm0 0" opacity="1" data-original="#ffd2c0" class=""></path><path fill="#edaa9d" d="M395.012 342.75h-61.598c-22.422 0-41.223-15.445-46.367-36.277a47.85 47.85 0 0 0-1.402 11.492c0 26.383 21.386 47.77 47.77 47.77h61.597c17.652 0 31.965-14.313 31.965-31.965v-22.985c0 17.653-14.313 31.965-31.965 31.965zm0 0" opacity="1" data-original="#edaa9d" class=""></path><path fill="hsl(var(--base))" d="M356.309 317.965c0 11.558-9.368 20.926-20.922 20.926-11.555 0-20.922-9.368-20.922-20.926 0-11.555 9.367-20.922 20.922-20.922 11.554 0 20.922 9.367 20.922 20.922zm0 0" opacity="1" data-original="#ce675d" class=""></path><path fill="#ffcd34" d="M283.844 426.379c0 47.289-38.332 85.621-85.617 85.621-47.29 0-85.622-38.332-85.622-85.621 0-47.285 38.332-85.617 85.622-85.617 47.285 0 85.617 38.332 85.617 85.617zm0 0" opacity="1" data-original="#ffcd34" class=""></path><g fill="#e69012"><path d="M235.965 349.52c16.332 15.59 26.523 37.562 26.523 61.921 0 47.286-38.332 85.621-85.62 85.621-13.548 0-26.348-3.16-37.735-8.761C154.5 502.973 175.3 512 198.227 512c47.285 0 85.617-38.332 85.617-85.621 0-33.738-19.524-62.906-47.88-76.86zm0 0" fill="#e69012" opacity="1" data-original="#e69012" class=""></path><path d="M227.082 441.148c0-12.28-9.988-22.27-22.27-22.27h-13.175c-4.008 0-7.27-3.257-7.27-7.265 0-4.008 3.262-7.27 7.27-7.27h25.218c4.141 0 7.5-3.359 7.5-7.5s-3.359-7.5-7.5-7.5h-9.71v-6.757c0-4.14-3.36-7.5-7.5-7.5s-7.5 3.36-7.5 7.5v6.758h-.508c-12.282 0-22.27 9.988-22.27 22.27 0 12.277 9.988 22.265 22.27 22.265h13.175c4.008 0 7.27 3.262 7.27 7.27 0 4.007-3.262 7.269-7.27 7.269h-25.218a7.5 7.5 0 1 0 0 15h12.55v6.754a7.5 7.5 0 1 0 15 0v-6.879c11.188-1.168 19.938-10.652 19.938-22.145zm0 0" fill="#e69012" opacity="1" data-original="#e69012" class=""></path></g></g></svg>
                                    </div>
                                    <p class="cart-step-title mb-0">
                                        @lang('Payment')
                                    </p>
                                </div>
                            </div>
                            <div class="col">
                                <div class="cart-step-box {{ menuActive('user.checkout.confirmation') }}">
                                    <div class="cart-step-icon mb-2">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="50" height="50" x="0" y="0" viewBox="0 0 64 64" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><g data-name="Layer 32"><path fill="#ffd164" d="M53.49 17.94a2 2 0 0 0-.1-.38s0 0 0-.06a.76.76 0 0 0-.09-.09 1 1 0 0 0-.13-.16l-.16-.1-.17-.08a.65.65 0 0 0-.2-.05h-.38a1.27 1.27 0 0 0-.18.06h-.06l-24.25 14-.09.09-.16.13a.86.86 0 0 0-.1.16.89.89 0 0 0-.08.17.65.65 0 0 0-.05.2s0 .08 0 .12v28.11a2 2 0 0 0 .1.38s0 0 0 .06a1.56 1.56 0 0 0 .16.2.92.92 0 0 0 .28.19h.08a.94.94 0 0 0 .34.07 1 1 0 0 0 .34-.07h.16l9.91-5.72a1 1 0 0 0 .15-.14.81.81 0 0 0 .14-.12 1.11 1.11 0 0 0 .09-.19.8.8 0 0 0 .08-.16 1.21 1.21 0 0 0 0-.19 1.28 1.28 0 0 0 0-.19 1.06 1.06 0 0 0-.06-.19 1.27 1.27 0 0 0-.06-.18 10.76 10.76 0 0 1 9.25-16.31 10.66 10.66 0 0 1 3.89.72.57.57 0 0 0 .18 0 .58.58 0 0 0 .18 0 1.09 1.09 0 0 0 .26 0 .61.61 0 0 1 .13 0l.15-.11a.76.76 0 0 0 .16-.11.61.61 0 0 0 .07-.1.68.68 0 0 0 .14-.23 1.22 1.22 0 0 0 0-.17 1.29 1.29 0 0 0 0-.19V18s.08 0 .08-.06z" opacity="1" data-original="#ffd164" class=""></path><path fill="#ffc350" d="m28.75 31.13-24.25-14h-.06a1.06 1.06 0 0 0-.19-.06h-.37a.8.8 0 0 0-.21.05l-.16.08-.16.1a1 1 0 0 0-.13.16l-.09.09v.06a1.27 1.27 0 0 0-.06.18 1.42 1.42 0 0 0 0 .2S3 18 3 18v28a1 1 0 0 0 .5.87l24.25 14h.16a1 1 0 0 0 .34.07.94.94 0 0 0 .34-.07h.08a.92.92 0 0 0 .28-.19 1.56 1.56 0 0 0 .16-.2s0 0 0-.06a1.27 1.27 0 0 0 .06-.18 1.42 1.42 0 0 0 0-.2V32a1 1 0 0 0-.42-.87z" opacity="1" data-original="#ffc350" class=""></path><path fill="#ffe17d" d="M53.48 18a1.21 1.21 0 0 1 0 .19 1.39 1.39 0 0 1-.06.19s0 .08 0 .12v.06l-.06.08a1.07 1.07 0 0 1-.25.22L40.3 26.2l-2 1.16-9.55 5.51a1 1 0 0 1-1 0l-24.25-14a1.07 1.07 0 0 1-.16-.14l-.13-.14V18.42a1.39 1.39 0 0 1-.21-.23 1.81 1.81 0 0 1 0-.38 1.39 1.39 0 0 1 .06-.19s0-.08 0-.12v-.05l.13-.14a1.07 1.07 0 0 1 .16-.14l11.9-6.87 1.91-1.1 10.44-6a1 1 0 0 1 1 0L53 17.13l.14.13.14.15V17.58a1.39 1.39 0 0 1 .06.19 1.21 1.21 0 0 1 .14.23z" opacity="1" data-original="#ffe17d"></path><path fill="#3cd400" d="M40.3 25.62v9.52a1 1 0 0 1-2 0v-9L15.4 10.26l1.91-1.1 22.54 15.63a1 1 0 0 1 .45.83zM48.25 35.5A12.75 12.75 0 1 0 61 48.25 12.76 12.76 0 0 0 48.25 35.5z" opacity="1" data-original="#e6646e" class=""></path><path fill="#fcfcfc" d="M46.8 53.84a1 1 0 0 1-.76-.35L42 48.71a1 1 0 0 1 1.53-1.29l3.25 3.82L53 43.06a1 1 0 1 1 1.59 1.21l-6.99 9.17a1 1 0 0 1-.77.4z" opacity="1" data-original="#5d5360" class=""></path></g></g></svg>
                                    </div>
                                    <p class="cart-step-title mb-0">
                                        @lang('Confirmation')
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <h5 class="mb-3 d-block d-sm-none">{{$pageTitle}}</h5>
                @yield('blade')
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .cart-link {
            position: absolute;
            top: 0;
            right: 0;
            height: 100%;
            width: 100%;
        }
        .cart-link:hover {
            background-color: hsl(var(--base) / 0.01);
        }
    </style>
@endpush
